<?php
/**
 * The Template for displaying all single posts.
 *
 * @package _tk
 */

get_header(); ?>

<?php $show_blog_nav = get_field('show_blog_nav','option'); ?>
<?php $show_blog_nav_title = get_field('show_blog_nav_title','option'); ?>

<div class="container margintop main-content">
	<?php if (get_field('show_sidebar','option') and get_field('show_sidebar_single','option')) { ?>
		<div class="col-sm-18<?php if (get_field('sidebar_position','option') == 'left') echo ' col-sm-push-6'; ?>">
	<?php } else { ?>
		<div class="col-sm-24">
	<?php } ?>
			<div class="row">
				<?php while ( have_posts() ) : the_post(); ?>

					<?php get_template_part( 'elements/content', 'single' ); ?>

					<?php if ($show_blog_nav and $show_blog_nav_title) 
						_tk_content_nav( 'nav-below' );
					elseif ($show_blog_nav and !$show_blog_nav_title) { ?>
						<ul class="pager">
							<li class="nav-previous previous">
								<?php previous_post_link( '%link', __('Previous post','_tk'), TRUE ); ?>
							</li>
							<li class="nav-next next">
								<?php next_post_link( '%link', __('Next post','_tk'), TRUE ); ?>
							</li>
						</ul>
					<?php }
					?>
					<?php _tk_pagination(); ?>

					<?php
						// If comments are open or we have at least one comment, load up the comment template
						if ( comments_open() || '0' != get_comments_number() )
							comments_template();
					?>

				<?php endwhile; // end of the loop. ?>
			</div>
		</div>

		<?php if (get_field('show_sidebar','option') and get_field('show_sidebar_single','option')) { ?>
			<div class="col-sm-6<?php if (get_field('sidebar_position','option') == 'left') echo ' col-sm-pull-18'; ?>">
				<?php get_sidebar(); ?>
			</div>
		<?php } ?>

</div>
<?php get_footer(); ?>